/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBMemoryRegionInfo;
import agent.lldb.manager.cmd.LldbReadMemoryCommand;
import agent.lldb.manager.cmd.LldbWriteMemoryCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.iface2.LldbModelTargetMemoryContainer;
import agent.lldb.model.iface2.LldbModelTargetMemoryRegion;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.impl.LldbModelTargetMemoryRegionImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.datastruct.WeakValueHashMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Memory", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=LldbModelTargetMemoryRegionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetMemoryContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetMemoryContainer {
    protected final LldbModelTargetProcess process;
    protected final Map<String, LldbModelTargetMemoryRegionImpl> memoryRegions = new WeakValueHashMap();

    public LldbModelTargetMemoryContainerImpl(LldbModelTargetProcess process) {
        super(process.getModel(), (TargetObject)process, "Memory", "MemoryContainer");
        this.process = process;
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listMemory(this.process.getProcess()).thenAccept(byName -> {
            List regions;
            LldbModelTargetMemoryContainerImpl lldbModelTargetMemoryContainerImpl = this;
            synchronized (lldbModelTargetMemoryContainerImpl) {
                regions = byName.stream().map(this::getTargetMemory).collect(Collectors.toList());
            }
            this.setElements(regions, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized LldbModelTargetMemoryRegion getTargetMemory(SBMemoryRegionInfo region) {
        TargetObject targetObject = this.getMapObject(region);
        if (targetObject != null) {
            LldbModelTargetMemoryRegion targetRegion = (LldbModelTargetMemoryRegion)targetObject;
            targetRegion.setModelObject(region);
            return targetRegion;
        }
        return new LldbModelTargetMemoryRegionImpl(this, region);
    }

    private byte[] readAssist(Address address, ByteBuffer buf, AddressSetView set) {
        if (set == null) {
            return new byte[0];
        }
        AddressRange range = set.getRangeContaining(address);
        if (range == null) {
            throw new DebuggerMemoryAccessException("Cannot read at " + String.valueOf(address));
        }
        this.broadcast().memoryUpdated((TargetObject)this.getProxy(), address, buf.array());
        return Arrays.copyOf(buf.array(), (int)range.getLength());
    }

    private void writeAssist(Address address, byte[] data) {
        this.broadcast().memoryUpdated((TargetObject)this.getProxy(), address, data);
    }

    @Override
    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        return this.model.gateFuture(this.doReadMemory(address, length));
    }

    protected CompletableFuture<byte[]> doReadMemory(Address address, int length) {
        LldbManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command readMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.allocate(length);
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new LldbReadMemoryCommand(manager, this.process.getProcess(), address, buf, buf.remaining())).thenApply(set -> this.readAssist(address, buf, (AddressSetView)set));
        }
        return CompletableFuture.completedFuture(new byte[length]);
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        return this.model.gateFuture(this.doWriteMemory(address, data));
    }

    protected CompletableFuture<Void> doWriteMemory(Address address, byte[] data) {
        LldbManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            throw new DebuggerModelAccessException("Cannot process command writeMemory while engine is waiting for events");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (!manager.isKernelMode() || address.getAddressSpace().getName().equals("ram")) {
            return manager.execute(new LldbWriteMemoryCommand(manager, this.process.getProcess(), address, buf, buf.remaining())).thenAccept(___ -> this.writeAssist(address, data));
        }
        return CompletableFuture.completedFuture(null);
    }
}

