/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import agent.lldb.model.iface2.LldbModelTargetConnector;
import agent.lldb.model.impl.LldbModelTargetConnectorContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ProcessRemoteConnector", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class LldbModelTargetProcessRemoteConnectorImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetConnector {
    protected final LldbModelTargetConnectorContainerImpl connectors;
    protected final TargetMethod.TargetParameterMap paramDescs;

    public LldbModelTargetProcessRemoteConnectorImpl(LldbModelTargetConnectorContainerImpl connectors, String name) {
        super(connectors.getModel(), (TargetObject)connectors, name, name);
        this.connectors = connectors;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_parameters", this.paramDescs), "Initialized");
    }

    @Override
    public CompletableFuture<Void> setActive() {
        this.connectors.setDefaultConnector(this);
        return CompletableFuture.completedFuture(null);
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        LinkedHashMap map = new LinkedHashMap();
        TargetMethod.ParameterDescription p0 = TargetMethod.ParameterDescription.create(String.class, (String)"Host", (boolean)true, (Object)"localhost", (String)"Host", (String)"host for connection");
        map.put("Host", p0);
        TargetMethod.ParameterDescription p1 = TargetMethod.ParameterDescription.create(String.class, (String)"Port", (boolean)true, (Object)"1234", (String)"Port", (String)"port for connection");
        map.put("Port", p1);
        TargetMethod.ParameterDescription p2 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Auto", (boolean)false, (Object)true, (String)"Auto", (String)"connect automatically");
        map.put("Auto", p2);
        TargetMethod.ParameterDescription p3 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Async", (boolean)false, (Object)true, (String)"Async", (String)"connect asynchronously");
        map.put("Async", p3);
        TargetMethod.ParameterDescription p4 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Kernel", (boolean)false, (Object)false, (String)"Kernel", (String)"use kernel plugin");
        map.put("Kernel", p4);
        return map;
    }

    @Override
    public TargetMethod.TargetParameterMap getParameters() {
        return TargetMethod.getParameters((TargetObject)this);
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, ?> args) {
        String host = (String)args.get("Host");
        String port = (String)args.get("Port");
        String url = "connect://" + host + ":" + port;
        Boolean auto = (Boolean)args.get("Auto");
        Boolean async = (Boolean)args.get("Async");
        Boolean kernel = (Boolean)args.get("Kernel");
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.getManager().connect(url, auto, async, kernel).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).nextIgnore(arg_0, arg_1))).finish().exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + String.valueOf(args));
        });
    }
}

