/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.manager.cmd.LldbAttachCommand;
import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface2.LldbModelTargetConnector;
import agent.lldb.model.iface2.LldbModelTargetRoot;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.impl.LldbModelDefaultTargetModelRoot;
import agent.lldb.model.impl.LldbModelImpl;
import agent.lldb.model.impl.LldbModelTargetAvailableContainerImpl;
import agent.lldb.model.impl.LldbModelTargetConnectorContainerImpl;
import agent.lldb.model.impl.LldbModelTargetProcessAttachByPidConnectorImpl;
import agent.lldb.model.impl.LldbModelTargetProcessImpl;
import agent.lldb.model.impl.LldbModelTargetProcessLaunchConnectorImpl;
import agent.lldb.model.impl.LldbModelTargetSessionContainerImpl;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Debugger", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Available", type=LldbModelTargetAvailableContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Connectors", type=LldbModelTargetConnectorContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Sessions", type=LldbModelTargetSessionContainerImpl.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetRootImpl
extends LldbModelDefaultTargetModelRoot
implements LldbModelTargetRoot {
    protected final LldbModelTargetAvailableContainerImpl available = new LldbModelTargetAvailableContainerImpl(this);
    protected final LldbModelTargetConnectorContainerImpl connectors = new LldbModelTargetConnectorContainerImpl(this);
    protected final LldbModelTargetSessionContainerImpl sessions = new LldbModelTargetSessionContainerImpl(this);
    protected String debugger = "kd";
    protected LldbModelSelectableObject focus;

    public LldbModelTargetRootImpl(LldbModelImpl impl, TargetObjectSchema schema) {
        super(impl, "Debugger", schema);
        LldbModelTargetConnector defaultConnector = this.connectors.getDefaultConnector();
        this.changeAttributes(List.of(), List.of(this.available, this.connectors, this.sessions), Map.of("_accessible", this.accessible, "_display", "Debugger", "_focus", this, "_supported_attach_kinds", LldbModelTargetProcessImpl.SUPPORTED_KINDS, "_parameters", defaultConnector.getParameters()), "Initialized");
        impl.getManager().addEventsListener(this);
    }

    @Override
    public LldbModelSelectableObject getFocus() {
        return this.focus;
    }

    @Override
    public void setDefaultConnector(LldbModelTargetConnector defaultConnector) {
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", defaultConnector.getParameters()), "Default connector changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(LldbModelSelectableObject sel) {
        boolean doFire;
        LldbModelTargetRootImpl lldbModelTargetRootImpl = this;
        synchronized (lldbModelTargetRootImpl) {
            boolean bl = doFire = !Objects.equals(this.focus, sel);
            if (doFire && this.focus != null) {
                List focusPath = this.focus.getPath();
                List selPath = sel.getPath();
                doFire = !PathUtils.isAncestor((List)selPath, (List)focusPath);
            }
        }
        if (doFire) {
            this.focus = sel;
            this.changeAttributes(List.of(), List.of(), Map.of("_focus", this.focus), "Focus changed");
        }
        return doFire;
    }

    @Override
    public CompletableFuture<Void> launch(List<String> args) {
        LldbModelTargetProcessLaunchConnectorImpl targetConnector = this.connectors.processLauncher;
        return this.model.gateFuture(targetConnector.launch(args)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + String.valueOf(args));
        });
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        LldbModelTargetConnector targetConnector = this.connectors.getDefaultConnector();
        return this.model.gateFuture(targetConnector.launch(args)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + String.valueOf(args));
        });
    }

    @Override
    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        LldbModelTargetProcessAttachByPidConnectorImpl targetConnector = this.connectors.processAttacherByPid;
        String key = attachable.getName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Pid", key.substring(1, key.length() - 1));
        return this.model.gateFuture(targetConnector.launch(map)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + key);
        });
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new LldbAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public void threadStateChanged(SBThread thread, StateType state, LldbCause cause, LldbReason reason) {
        LldbModelTargetThread targetThread = (LldbModelTargetThread)this.getModel().getModelObject(thread);
        this.changeAttributes(List.of(), List.of(), Map.of("_event_thread", targetThread), reason.desc());
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }
}

