/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.error.LowlevelError;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import java.math.BigInteger;

public class ARMEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    private Register TModeReg;
    private Register TBreg;
    private RegisterValue tMode;
    private RegisterValue aMode;

    public ARMEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.TModeReg = this.language.getRegister("TMode");
        this.TBreg = this.language.getRegister("ISAModeSwitch");
        if (this.TModeReg != null) {
            if (this.TBreg == null) {
                throw new RuntimeException("Expected language " + String.valueOf(this.language.getLanguageID()) + " to have ISAModeSwitch register defined");
            }
            this.tMode = new RegisterValue(this.TModeReg, BigInteger.ONE);
            this.aMode = new RegisterValue(this.TModeReg, BigInteger.ZERO);
        }
    }

    public void initialExecuteCallback(Emulate emulate, Address current_address, RegisterValue contextRegisterValue) throws LowlevelError {
        if (this.TModeReg == null) {
            return;
        }
        BigInteger tModeValue = BigInteger.ZERO;
        if (contextRegisterValue != null) {
            tModeValue = contextRegisterValue.getRegisterValue(this.TModeReg).getUnsignedValueIgnoreMask();
        }
        if (!BigInteger.ZERO.equals(tModeValue)) {
            tModeValue = BigInteger.ONE;
        }
        this.emu.getMemoryState().setValue(this.TBreg, tModeValue);
    }

    public void postExecuteCallback(Emulate emulate, Address lastExecuteAddress, PcodeOp[] lastExecutePcode, int lastPcodeIndex, Address currentAddress) throws LowlevelError {
        if (this.TModeReg == null) {
            return;
        }
        if (lastPcodeIndex < 0) {
            return;
        }
        int lastOp = lastExecutePcode[lastPcodeIndex].getOpcode();
        if (lastOp != 4 && lastOp != 5 && lastOp != 6 && lastOp != 7 && lastOp != 8 && lastOp != 10) {
            return;
        }
        long tbValue = this.emu.getMemoryState().getValue(this.TBreg);
        if (tbValue == 1L) {
            this.emu.setContextRegisterValue(this.tMode);
            if ((currentAddress.getOffset() & 1L) == 1L) {
                emulate.setExecuteAddress(currentAddress.previous());
            }
        } else if (tbValue == 0L) {
            if ((currentAddress.getOffset() & 1L) == 1L) {
                throw new LowlevelError("Flow to odd address occurred without setting TB register (Thumb mode)");
            }
            this.emu.setContextRegisterValue(this.aMode);
        }
    }
}

